document.addEventListener('DOMContentLoaded', () => {
    // Load data from storage
    chrome.storage.local.get(['seoData'], (result) => {
        if (result.seoData) {
            populateForm(result.seoData);
        }
    });

    document.getElementById('btnGenerate').addEventListener('click', generateMasterPrompt);
    document.getElementById('btnCopy').addEventListener('click', copyToClipboard);
});

// Restored populateForm
function populateForm(data) {
    document.getElementById('inputTitle').value = data.title || '';

    // Format Headings for the "As It Is" section
    const headingsTxt = data.headings.map(h => `${h.tag}: ${h.text}`).join('\n');
    document.getElementById('inputHeadings').value = headingsTxt;

    document.getElementById('inputNLP').value = data.nlp || '';
    document.getElementById('inputLSI').value = data.lsi || '';
}

function generateMasterPrompt() {
    const title = document.getElementById('inputTitle').value;
    const country = document.getElementById('inputCountry').value || 'USA';
    const headings = document.getElementById('inputHeadings').value;
    const nlp = document.getElementById('inputNLP').value;
    const lsi = document.getElementById('inputLSI').value;
    const allKeywords = [nlp, lsi].filter(x => x).join(', ');

    // User's Exact 3-Part Prompt Template
    const masterPrompt = `1st part of the Prompt

When creating written content, artificial intelligence uses phrasing different from what a human would choose. Utilize uncommon terminology to enhance the originality of the piece. Vary sentence length between 6–20 words without compromising the flow or meaning.
Research thoroughly
Hook readers with each topic sentence start
Utilize transition words
Provide valuable information
Ensure that each paragraph
When writing, follow these instructions below: Use active voice instead of passive wherever possible. Passive voice can sound stiff. For example, “The book was read by me” sounds less human than “I read the book.”
Vary your sentence structure. Don’t just use simple subject-verb-object sentences. Try starting sentences in different ways, use dependent clauses, etc. to make it sound less formulaic.
Avoid overusing complicated words when simpler ones will do. Using too many long, obscure words can sound pretentious.
Use contractions like don’t, isn’t, or I’ll to sound more conversational. But don’t overdo it.
Break up long sentences. Human speech tends to come in shorter sentences and phrases.
Read your writing out loud. Does it sound like something you’d actually say? If not, revise it to be more natural sounding.
Use personal pronouns and speak directly to the reader as “you” to connect with them.
Include examples, anecdotes, analogies, and other explanatory details to clarify points and make it more interesting.
Use varied vocabulary. Don’t repeat the exact same words and phrases over and over.
Use natural sounding transitions like “However…” or “For example…” to link ideas.
Be concise. Don’t use three words when one will do.
Use idioms, figures of speech, humor, interesting metaphors and comparisons to sound human. But use them thoughtfully, not excessively.
The key is to read your writing from the perspective of your audience. Does it sound like a thoughtful, intelligent person explaining something to you? Keep polishing until it flows naturally.
Also consider:
Two factors must always be taken into account: perplexity and burstiness.
Perplexity measures the complexity of text.
Burstiness assesses variations between sentences.
Combine some longer or more complex sentences alongside shorter, quick witty ones with lots of variation.
Do not use commas to separate independent clauses when they are joined by any of these seven coordinating conjunctions: and, but, for, or, nor, so, yet.
Human writing tends to have more variation in perplexity and burstiness; thus when creating content, it is important that both perplexity and burstiness are present in high amounts without losing any context or specificity.
Respond only in ENGLISH.
Write content that will always outrank other websites.
Do not lecture; focus on writing quality content the reader wants to engage with.
Use URLs and hyperlinks when referencing a source.
Use diagrams, lists and tables when necessary.
Write only 2 paragraphs of H2 headings and only 1 paragraph of H3 headings in easy English.
Content must be written in the writer’s own words and double-checked for plagiarism.
Article needs to have a conversational style as if it were written by a friendly and happy human.
Under every heading contains a maximum of 40 to 50 words. Bold maximum 2 to 3 LSI keywords in each paragraph. Use the focus keyword minimum of 6 times and a maximum of 7 times throughout the article.
If my competitor has provided more information, ensure to provide even more information than them, including new and unique details they haven’t mentioned. This will help my article rank at the top and grab the reader’s attention, ultimately increasing traffic to my website.
Do you understand? These are the instructions for all of the writing you will be doing. “Also, the introduction should have two paragraphs, and each paragraph must include five LSI keywords. Both paragraphs should be written in an SGE-style so they are AI-powered and can appear in Google AI Overviews. The introductory paragraphs should include the author’s experience, a clear promise about the related content, and an emotional connection with the reader.”

2nd Prompt It will make a Structure

Now following those instructions: Your first task is to write an in-depth and comprehensive blog post outline for an article about: “${title}” This blog post/ Article is targeting -${country}- Audience.
Keep in mind this is also the target keyword we are trying to rank for so include it and variations of the keyword in the h1, h2, h3 and throughout the article.
Must include these headings As It Is (
${headings}
)

3rd Prompt For Complete Article

Now using the outline generated, write an in-depth, comprehensive and informative blog post in easy English. Please don’t use bullet points.
Remember to include long paragraphs with in-depth knowledge on each outline.
Include useful and deep knowledge for the blog post topic and outline.
Always include lists, facts, and tables when applicable. Always write in markdown format.
Also write in a simple, easy to read style. Also include lists, tables, case studies, quotes, bolded words.
Create a title as well. Keep in mind the target keyword, so include this keyword and variations of the keyword in the h1, h2, h3 tags and naturally throughout the article. Don’t use bullet points in the whole article.
Must include these LSI keywords naturally throughout the article as it is: (
${lsi}
) Also bold all LSI and NLP’s (
${allKeywords}
) and write each H2 heading short 2 paragraphs also add table or bullet points if needed otherwise not., please write the whole article in short sentences using easy English.`;

    document.getElementById('finalOutput').value = masterPrompt;
    document.getElementById('outputSection').style.display = 'block';
    document.getElementById('outputSection').scrollIntoView({ behavior: 'smooth' });
}

function copyToClipboard() {
    document.getElementById('finalOutput').select();
    document.execCommand('copy');

    const btn = document.getElementById('btnCopy');
    btn.textContent = "Copied!";
    setTimeout(() => btn.textContent = "Copy Text", 2000);
}
