// Background script to handle external messages from the website

chrome.runtime.onMessageExternal.addListener(
    (request, sender, sendResponse) => {
        if (request.type === "AUTH_SYNC") {
            console.log("Received AUTH_SYNC from website:", request.user);

            // Save user data to local storage
            chrome.storage.local.set({ user: request.user }, () => {
                console.log("User data synced to extension storage.");
                sendResponse({ status: "success", message: "User synced" });
            });

            // Return true to indicate we wish to send a response asynchronously
            return true;
        }

        if (request.type === "AUTH_LOGOUT") {
            console.log("Received AUTH_LOGOUT from website");

            // Clear user data
            chrome.storage.local.remove("user", () => {
                console.log("User logged out from extension.");
                sendResponse({ status: "success", message: "User logged out" });
            });

            return true;
        }
    }
);
